#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Julia Fractal Orbit Trap   by  JuliaPoo
//https://www.shadertoy.com/view/WdtBRS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_ITER 500
#define INF 100.

#define col1 vec3(1., .3, .4)
#define col2 vec3(.4, 1., .2)
#define col3 vec3(.3, .4, 1.)

float trap(in vec2 uv, in vec2 p) {
    float txt = texture(iChannel0, uv).x;
    return distance(uv, p) * (txt + 1.);
}

float shake(float off)
{
    return sin(iTime*.5 + off) + .2*sin(iTime*.7+.5 + off*.3) + .1*sin(iTime+.3 + off*.7);
}

vec3 render(in vec2 uv)
{
    float s = .13*sin(iTime*.3);
    vec2 c = vec2(-0.77568377,0.134646737) + s*s;
    int i = 0;
    
    float mdist1 = INF; float mdist2 = INF; float mdist3 = INF;
    float dist1, dist2, dist3; 
    for (i=0; i<MAX_ITER; ++i)
    {
        if (uv.x*uv.x + uv.y*uv.y > 4.) break;
        
        uv = vec2(uv.x*uv.x - uv.y*uv.y, 2.*uv.x*uv.y) + c;
        
        dist1 = trap(uv, vec2(0.,0.));
        dist2 = trap(uv, vec2(0.,.5));
        dist3 = trap(uv, vec2(.5,0.));
        
        if (mdist1 > dist1) mdist1 = dist1;
        if (mdist2 > dist2) mdist2 = dist2;
        if (mdist3 > dist3) mdist3 = dist3;
    }
    
    // Compute smooth iteration:
    // https://iquilezles.org/articles/msetsmooth
    float iter = float(i) - log2(log2(dot(uv,uv))) + 4.0;
    iter /= float(MAX_ITER);
    
    vec3 col = mdist1*col1 + mdist2*col2 + mdist3*col3;
    col *= (cos(iter*1.57)+.6)/2.;
    col *= col;
    col = 1.-col;
    
    return clamp(vec3(col), 0.,1.);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float s1, s2;
    s1 = shake(0.); s2 = shake(1.5);
    
    vec2 uv = (1.9 + .1*s1)*(fragCoord/iResolution.xy - .5);
    uv.x *= iResolution.x/iResolution.y;
    
    vec3 col = render(uv);
    vec3 w = vec3(2.,.2,.1);
    col += vec3(.1,-.7,.2)*(length(w) - dot(col, w));
    col = pow(col, vec3(1., 1.5, 1.9));
    
    fragColor = vec4(col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

